mesdata1 = sinusdata;

start1=mean(mesdata1);
phasestart1 = 0;

startamp1 = (max(mesdata1)-min(mesdata1))/2;

[pks1,locs1] = findpeaks(smooth(mesdata1,2),'MinPeakDistance',15);

frequencyfit1 = 2*pi/(mean(diff(locs1)));


start = [startamp1,frequencyfit1,phasestart1,start1];
low = [0,frequencyfit1-0.05*frequencyfit1, -pi, -1];
up = [100,frequencyfit1+0.05*frequencyfit1,  pi ,1];

optionsforfit = fitoptions('Method', 'NonlinearLeastSquares','MaxIter',200,'TolFun',10^-10,'TolX',10^-10,'Upper',up,'Lower',low,'StartPoint',start);
g = fittype('a*sin(b*t+c)+d','independent','t','options', optionsforfit);
t1 = 1:length(mesdata1);
[f1,gof] = fit(t1',mesdata1',g);

amp1 =f1.a;
faults = confint(f1,0.95);
amp1_fault=(-faults(1,1)+faults(2,1))/2;

phase1 = f1.c/pi;

%if gof.rsquare<0.95
%     disp(['Warning! Bad sinus fit for ' foldername]);
%     figure;
%     hold on
%      plot(mesdata1)
%      plot(f1)
%     hold off
%     menu(sprintf(['Warning! Bad sinus fit for ' foldername]),'ok','ok, of course');
%end



